﻿using System;
using System.IO;
using System.Threading;
using System.Windows;

namespace Affinity
{
    /// <summary>
    /// Logika interakcji dla pliku MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            // Zapewniamy, że plik dziennika, który później odczytamy, będzie miał 
            // jakąś zawartość.
            using (StreamWriter w = File.AppendText(@"c:\temp\log.txt"))
            {
                w.WriteLine("Aplikacja została uruchomiona o " + DateTime.Now);
            }
        }

        private void runWorkAsyncButton_Click(object sender, RoutedEventArgs e)
        {
            // Listing 16-7. Obsługa powinowactwa do wątku przy użyciu klasy SynchronizationContext
            SynchronizationContext originalContext = SynchronizationContext.Current;

            ThreadPool.QueueUserWorkItem(delegate
            {
                string text = File.ReadAllText(@"c:\temp\log.txt");
                originalContext.Post(delegate
                {
                    myTextBox.Text = text;
                }, null);
            });
        }
    }
}
